
ells := [ 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101,
103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211,
223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337,
349, 353, 367, 373, 379, 383, 389 ];
p := 2^3*3*&*ells - 1;
// "degree of the isogenies :";
// ells;



function step_zero_Montgomery_min(X1, Z1, X2, Z2, X3, Z3, A)
  return (X2^2+Z2^2)^2, 4*X2*Z2*(X2^2+A*X2*Z2-Z2^2), 4*(X2*X3+Z2*Z3)^2*Z1, 4*(X2*Z3-Z2*X3)^2*X1;
end function;


function step_one_Montgomery_min(X1, Z1, X3, Z3, X2, Z2, A)
  return 4*(X2*X3+Z2*Z3)^2*Z1, 4*(X2*Z3-Z2*X3)^2*X1, (X2^2+Z2^2)^2, 4*X2*Z2*(X2^2+A*X2*Z2-Z2^2);
end function;


function scalar_multiplication_Montgomery_min(n, X1, Z1, A)
  X2 := 1; Z2 := 0; X3 := X1; Z3 := Z1;
  nbits := Reverse(Intseq(n,2));
  if Z1 eq 0 then return "Error";
  else for i := 1 to #nbits do
    if nbits[i] eq 0 then X2, Z2, X3, Z3 := step_zero_Montgomery_min(X1, Z1, X2, Z2, X3, Z3, A);
    else X2, Z2, X3, Z3 := step_one_Montgomery_min(X1, Z1, X2, Z2, X3, Z3, A);
    end if;
  end for;
  return X2, Z2;
  end if;
end function;

function double_point_Montgomery_min(X2, Z2, A)
  if Z2 eq 0 or X2^3+A*X2^2+X2 eq 0 then return 0, 0;
  else return (X2^2+Z2^2)^2, 4*X2*Z2*(X2^2+A*X2*Z2-Z2^2);
  end if;
end function;
function differential_addition_Montgomery_min(X1, Z1, X2, Z2, X3, Z3, A)
  if X1 eq 0 or Z1 eq 0 or [X2,Z2] eq [0,0] or [X3,Z3] eq [0,0] then return 0, 0;
  else
    return 4*(X2*X3+Z2*Z3)^2*Z1, 4*(X2*Z3-Z2*X3)^2*X1;
  end if;
end function;





xDBL:=function(P,A)
  x,z:=double_point_Montgomery_min(P[1],P[2],A);
  if z eq 0 then
    return [0,0];
  end if;
  return [x/z,Parent(x)!1];
end function;
xADD:=function(P,Q,PmQ,A)
  if P eq [0,0] then
    return Q;
  elif Q eq [0,0] then
    return P;
  elif PmQ eq [0,0] then
    return xDBL(P,A);
  end if;
  x,z:=differential_addition_Montgomery_min(PmQ[1],PmQ[2],Q[1],Q[2],P[1],P[2],A);
  if z eq 0 then
    return [0,0];
  end if;
  return [x/z,Parent(x)!1];
end function;
Ladder:=function(m,x,A)
  X,Z:=scalar_multiplication_Montgomery_min(m,x[1],x[2],A);
  if Z eq 0 then
    return [0,0];
  end if;
  return [X/Z,Parent(X)!1];
end function;

//height is log_2(#points)+1
SubProductTree:=function(points,height)
  Q<x>:=PolynomialRing(Parent(points[1]));
  tree:=[Q!0 : i in [1..2^(height)]];
  //first non binary step :
  for i in [1..#points] do
    tree[2^(height-1)-1+i]:=x-points[i];
  end for;
  for k in [1..(height-1)] do
    for i in [1..2^(height-1-k)] do
      index:=2^(height-1-k)-1+i;
      if tree[2*index+1] eq 0 and tree[2*index] ne 0 then
        tree[index]:=tree[2*index];
      else
        tree[index]:=tree[2*index]*tree[2*index+1];
      end if;
    end for;
  end for;
  return tree;
end function;

SubProductTreePolynomials:=function(polys,height)
  zero:=0*polys[1];
  tree:=[zero : i in [1..2^(height)]];
  //first non binary step :
  for i in [1..#polys] do
    tree[2^(height-1)-1+i]:=polys[i];
  end for;
  for k in [1..(height-1)] do
    for i in [1..2^(height-1-k)] do
      index:=2^(height-1-k)-1+i;
      if tree[2*index+1] eq 0 and tree[2*index] ne 0 then
        tree[index]:=tree[2*index];
      else
        tree[index]:=tree[2*index]*tree[2*index+1];
      end if;
    end for;
  end for;
  return tree;
end function;

MultipointEvaluation:=function(points,tree,P,height)
  zero:=0*tree[1];
  tree_eval:=[zero: i in [1..#tree]];
  tree_eval[1]:= P mod tree[1];
  for k in [1..(height-1)] do
    for i in [1..2^k] do
      index:=2^k-1+i;
      if tree[index] eq 0 then
        tree_eval[index]:=0;
      else
        tree_eval[index]:=tree_eval[Floor(index/2)] mod tree[index];
      end if;
    end for;
  end for;
  eval_multipoint:=[Parent(points[1])!0: i in [1..#points]];
  for i in [1..#points] do

    eval_multipoint[i]:=Evaluate(tree_eval[2^(height-1)-1+i],points[i]);
  end for;
  return eval_multipoint;
end function;


evaluate_isogeny_big_degree:=function(isog,P,l)
	if P eq [0,0] then
		return [0,0];
	end if;
  if P eq [0,1] then
    return [0,1];
  end if;
	v:=P[1];
	h1:=isog[1];p1:=isog[2];tree1:=isog[3];poly1:=isog[4];poly2:=isog[5];
	p3:=isog[6];poly4:=isog[7];
  // polyB1:=isog[8];polyB2:=isog[9];
	// pB3:=isog[10];polyB4:=isog[11];
  ptemp3:=[UnivariatePolynomial(Evaluate(poly3,2,v)): poly3 in p3];
  poly3:=&*ptemp3;

  denom:=Evaluate(poly1,v)*Evaluate(poly2,v)*Evaluate(poly4,v)*(&*MultipointEvaluation(p1,tree1,poly3,h1));
  if denom eq 0 then
    return [0,0];
  end if;
  // num:=Evaluate(polyB1,v)*Evaluate(polyB2,v)*Evaluate(polyB4,v)*(&*MultipointEvaluation(p1,tree1,polyB3,h1));
  ptempB3:=[UnivariatePolynomial(Evaluate(polyB3,2,-1/v)): polyB3 in p3];
  polyB3:=&*ptempB3;
  num1:=Evaluate(poly1,-1/v)*Evaluate(poly2,-1/v)*Evaluate(poly4,-1/v)*(&*MultipointEvaluation(p1,tree1,polyB3,h1));
  // (v*(num/denom)^2) eq ;
  return [v^l*(num1/denom)^2,Parent(P[1])!1];
end function;

kernel_generator_to_isogeny_big_degree:=function(A0,P,l,alpha)

  _<o>:=PolynomialRing(Parent(A0));
  E0:=EllipticCurve(o^3+A0*o^2-o);
  m:=Floor(Sqrt(l/2));
  k:=Floor(m/2);
  if m^2+m ge Ceiling(l/2) then
    m:=m-1;
  end if;
  _<x>:=PolynomialRing(BaseRing(E0));
  _<y,T>:=PolynomialRing(BaseRing(E0),2);
  p1:=[P[1]];
  // pB1:=[x*P[1]+1];
  Ptemp:=P;
  // Ptempr:=Pr;
  Pdiff:=[0,0];
  // Q:=2*m*P;
  Q:=Ladder(2*m,P,A0);
  // Qtemp:=Q;
  Qtemp:=Q;
  // Qtempr[1] eq Qtemp[1];
  Qdiff:=[0,0];
  // Stemp:=m*P;
  Stemp:=Ladder(m,P,A0);
  // Stemp[1] eq Stempr[1];
  Sdiff:=Stemp;
  // Stemp[1] eq Stempr[1];
  p2:=[Q[1]-x];
  // pB2:=[Q[1]*x+1];
  p3:=[(y-Q[1])^2*T^2 - T*2*(-y-Q[1]+y*Q[1]*(2*A0+y+Q[1]))+(y*Q[1]+1)^2];
  // pB3:=[(y-Q[1])^2 + T*2*(-y-Q[1]+y*Q[1]*(2*A0+y+Q[1]))+T^2*(y*Q[1]+1)^2];
  p4:=[x-Stemp[1]];
  // pB4:=[(x*Stemp[1]+1)];

  for i in [2..(m-1)] do
    // Ptemp:=Ptemp+P;
    Pttemp:=Ptemp;
    Ptemp:=xADD(Ptemp,P,Pdiff,A0);
    Pdiff:=Pttemp;
    // Ptemp[1] eq Ptempr[1];
    Append(~p1,Ptemp[1]);
    // Append(~pB1,(x*Ptemp[1]+1));
  end for;
  for i in [2..k] do
      // Qtemp+:=Q;
      // Stemp+:=Q;
      Qttemp:=Qtemp;
      Qtemp:=xADD(Qtemp,Q,Qdiff,A0);
      Qdiff:=Qttemp;
      // Qtempr[1] eq Qtemp[1];
      Sttemp:=Stemp;
      Stemp:=xADD(Stemp,Q,Sdiff,A0);
      Sdiff:=Sttemp;

    Append(~p2,(x-Qtemp[1]));
    // Append(~pB2,(x*Qtemp[1]+1));
    Append(~p4,(x-Stemp[1]));
    // Append(~pB4,(x*Stemp[1]+1));
    Append(~p3,(y-Qtemp[1])^2*T^2 - T*2*(-y-Qtemp[1]+y*Qtemp[1]*(2*A0+y+Qtemp[1]))+(y*Qtemp[1]+1)^2);
    // Append(~pB3,(y-Qtemp[1])^2+ T*2*(-y-Qtemp[1]+y*Qtemp[1]*(2*A0+y+Qtemp[1]))+T^2*(y*Qtemp[1]+1)^2);
  end for;
  R:=Ladder(2*k*m+m,P,A0);
  Rdiff:=Ladder(2*k*m+m-1,P,A0);
  Append(~p4,x-R[1]);
  // Append(~pB4,x*R[1]+1);
  Rtemp:=R;
  for i in [(2*k*m+m+1)..Floor(l/2)] do
    Rttemp:=Rtemp;
    Rtemp:=xADD(Rtemp,P,Rdiff,A0);
    Rdiff:=Rttemp;
    // Rtempr[1] eq Rtemp[1];
    Append(~p4,(x-Rtemp[1]));
    // Append(~pB4,(x*Rtemp[1]+1));
  end for;
  h1:=Ceiling(Log(#p1)/Log(2))+1;
  h2:=Ceiling(Log(#p2)/Log(2))+1;
  h3:=Ceiling(Log(#p3)/Log(2))+1;
  h4:=1+Ceiling(Log(#p4)/Log(2))+1;

  tree1:=SubProductTree(p1,h1);
  tree2:=SubProductTreePolynomials(p2,h2);
  tree4:=SubProductTreePolynomials(p4,h4);
  // treeB1:=SubProductTreePolynomials(pB1,h1);
  // treeB2:=SubProductTreePolynomials(pB2,h2);
  // treeB4:=SubProductTreePolynomials(pB4,h4);
  poly1:=tree1[1];poly2:=tree2[1];

	poly1:=tree1[1];poly2:=tree2[1];poly4:=tree4[1];
  // polyB1:=treeB1[1];polyB2:=treeB2[1];polyB4:=treeB4[1];
	// isogeny:=<h1,p1,tree1,poly1,poly2,p3,poly4,polyB1,polyB2,pB3,polyB4>;
  isogeny:=<h1,p1,tree1,poly1,poly2,p3,poly4>;
	phixt:=evaluate_isogeny_big_degree(isogeny,[alpha,1],l)[1];

	A:=-(-1+phixt^2)/phixt;
  return A,isogeny,phixt;


  //moody shumov method... the formulas are wrong
  // a:=A0+2;
  // d:=A0-2;
  // ptemp3:=[UnivariatePolynomial(Evaluate(poly3,2,1)): poly3 in p3];
  // poly3:=&*ptemp3;
  // prod3:=Evaluate(poly1,1)*Evaluate(poly2,1)*Evaluate(poly4,1)*(&*MultipointEvaluation(p1,tree1,poly3,h1));
  // ptemp3:=[UnivariatePolynomial(Evaluate(poly3,2,-1)): poly3 in p3];
  // poly3:=&*ptemp3;
  // prod4:=Evaluate(poly1,-1)*Evaluate(poly2,-1)*Evaluate(poly4,-1)*(&*MultipointEvaluation(p1,tree1,poly3,h1));
  // a1:=a^(l)*prod3^8;
  // d1:=d^(l)*prod4^8;
  // A:=2*(a1+d1)/(-a1+d1);
  // return A,isogeny,Parent(A)!1;
  // return A,isogeny,phixt
end function;

function act_with_small_ell_on_Montgomery_min(A, ell, xTors, xPush)
  XQ := xTors; ZQ := 1;
  pi := XQ; sigma := XQ + 1/XQ;
  fXPush := (XQ*xPush+1); fZPush := (xPush-XQ);
  // fXPush := xPush*(XQ*xPush+1)^2; fZPush := (xPush-XQ)^2;
  if ell eq 3 then return pi^2*(A-6*sigma), xPush*fXPush^2, fZPush^2;
  // if ell eq 3 then return pi^2*(A-6*sigma), fXPush, fZPush;
  else
  XQ, ZQ := double_point_Montgomery_min(XQ, ZQ, A); xQ := XQ/ZQ;
  pi *:= xQ; sigma +:= xQ + 1/xQ;
  fXPush *:= (xPush*xQ+1); fZPush *:= (xPush - xQ);
  // fXPush *:= (xPush*xQ+1)^2; fZPush *:= (xPush - xQ)^2;
  XPrev := xTors; ZPrev := 1;
  for i in [3..(ell-1) div 2] do
    XTemp := XQ; ZTemp := ZQ;
    XQ, ZQ := differential_addition_Montgomery_min(XPrev, ZPrev, xTors, 1, XQ, ZQ, A); xQ := XQ/ZQ;
    pi *:= xQ; sigma +:= xQ + 1/xQ;
    fXPush *:= (xPush*xQ+1); fZPush *:= (xPush - xQ);
    // fXPush *:= (xPush*xQ+1)^2; fZPush *:= (xPush - xQ)^2;
    XPrev := XTemp; ZPrev := ZTemp;
  end for;
  end if;
  return pi^2*(A - 6*sigma), xPush*fXPush^2, fZPush^2;
  // return pi^2*(A-6*sigma), fXPush, fZPush;
end function;


function act_with_big_ell_on_Montgomery_min(A, ell, xTors, xPush,alpha)
  F:=Parent(xTors);
  Af,isog,alphaf:=kernel_generator_to_isogeny_big_degree(A,[xTors,F!1],ell,alpha);
  fXpush:=evaluate_isogeny_big_degree(isog,[xPush,F!1],ell);
  return Af,fXpush[1],fXpush[2],alphaf;
  // return Af,fXpush[1],fXpush[2];
end function;

function act_with_ell_on_Montgomery_min(A, ell, xTors, xPush,degree_bound)
  if ell le degree_bound then
    return act_with_small_ell_on_Montgomery_min(A,ell,xTors,xPush);
  else
    return act_with_big_ell_on_Montgomery_min(A,ell,xTors,xPush,Parent(A)!1);
  end if;
end function;




function act_with_two_on_Montgomery_min(A, exp)
  A *:= Sign(exp);
  p := #Parent(A);
  sq_exp := (p+1) div 4;
  delta := (A^2 + 4)^sq_exp;
  if exp eq 0 then
    return A;
  else
    A := 2*(A-3*delta)/(A+delta);
  end if;
  for i in [2..Abs(exp)] do
    eps := (A^2 - 4)^sq_exp;
    A := 2*(3 - A*(A - eps));
  end for;
  eps := (A^2 - 4)^sq_exp;
  scalefac := (eps*(eps + A)/2)^sq_exp;
  return Sign(exp)*(-A-3*eps)/(2*scalefac);
end function;

function csurf_action(private_key, A)
  ells := [ 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101,
  103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211,
  223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337,
  349, 353, 367, 373, 379, 383, 389 ];
  p := 2^3*3*&*ells - 1;
  F := GF(p);
  A := F ! A;
  A := act_with_two_on_Montgomery_min(A,private_key[1]);
  private_key := Remove(private_key, 1);
  while private_key ne [0 : i in [1..74]] do
    xP := Random(F);
    twist := not IsSquare(xP^3+A*xP^2-xP); if twist then A := -A; xP := -xP; end if;
    indices_ells_correct_sign := [];
    k := 1;
    for i := 1 to #ells do
      if private_key[#ells-i+1] gt 0 and not twist then Append(~indices_ells_correct_sign,#ells-i+1); k *:= ells[#ells-i+1];
      elif private_key[#ells-i+1] lt 0 and twist then Append(~indices_ells_correct_sign,#ells-i+1); k *:= ells[#ells-i+1];
      end if;
    end for;
    XQ, ZQ := scalar_multiplication_Montgomery_min((p+1) div k, xP, 1, A);
    for i in indices_ells_correct_sign do
      if ells[i] eq 3 then
        if ZQ ne 0 then
          xQ := XQ/ZQ;
          XR9, ZR9 := scalar_multiplication_Montgomery_min(k div 3, xQ, 1, A);
          if ZR9 ne 0 then
            XR, ZR := scalar_multiplication_Montgomery_min(3, XR9/ZR9, 1, A);
            if ZR eq 0 then
              A, XQ, ZQ := act_with_ell_on_Montgomery_min(A, 3, XR9/ZR9, xQ);
              if twist then private_key[i] +:= 1; else private_key[i] -:= 1; end if;
            else
              A, XQ, ZQ := act_with_ell_on_Montgomery_min(A, 3, XR/ZR, xQ);
              if twist then private_key[i] +:= 1; else private_key[i] -:= 1; end if;
            end if;
          end if;
        end if;
      else
        if ZQ ne 0 then
          xQ := XQ/ZQ;
          ell := ells[i];
          XR, ZR := scalar_multiplication_Montgomery_min(k div ell, xQ, 1, A);
          if ZR ne 0 then
            A, XQ, ZQ := act_with_ell_on_Montgomery_min(A, ell, XR/ZR, xQ);
            if twist then private_key[i] +:= 1; else private_key[i] -:= 1; end if;
          end if;
        end if;
      end if;
    end for;
    if twist then A := -A; end if;
  end while;
  return A;
end function;

function csurf_action_old(private_key,A)

  F := GF(p);
  A := F ! A;
  A := act_with_two_on_Montgomery_min(A,private_key[1]);
  private_key := Remove(private_key, 1);
  _<o>:=PolynomialRing(F);

  while private_key ne [0 : i in [1..74]] do
    xP := Random(F);
    twist := not IsSquare(xP^3+A*xP^2-xP); if twist then A := -A; xP := -xP; end if;
    indices_ells_correct_sign := [];
    k := 1;
    for i := 1 to #ells do
      if private_key[i] gt 0 and not twist then Append(~indices_ells_correct_sign,i); k *:= ells[i];
      elif private_key[i] lt 0 and twist then Append(~indices_ells_correct_sign,i); k *:= ells[i];
      end if;
    end for;
    XQ, ZQ := scalar_multiplication_Montgomery_min((p+1) div k, xP, 1, A);
    for i in indices_ells_correct_sign do
      if ells[i] eq 3 then
        if ZQ ne 0 then
          xQ := XQ/ZQ;
          // k:=k div 3;
          XR9, ZR9 := scalar_multiplication_Montgomery_min(k div 3, xQ, 1, A);
          if ZR9 ne 0 then
            XR, ZR := scalar_multiplication_Montgomery_min(3, XR9/ZR9, 1, A);
            if ZR eq 0 then
              A, XQ, ZQ := act_with_small_ell_on_Montgomery_min(A, 3, XR9/ZR9, xQ);
              if twist then private_key[i] +:= 1; else private_key[i] -:= 1; end if;
            else
              A, XQ, ZQ := act_with_small_ell_on_Montgomery_min(A, 3, XR/ZR, xQ);
              if twist then private_key[i] +:= 1; else private_key[i] -:= 1; end if;
            end if;
          end if;
        end if;
      else
        if ZQ ne 0 then
          xQ := XQ/ZQ;
          ell := ells[i];
          // k:=k div ell;
          XR, ZR := scalar_multiplication_Montgomery_min(k div ell, xQ, 1, A);
          if ZR ne 0 then
            // E:=EllipticCurve(o^3+A*o^2-o);
            // DivisionPoints(Id(E),2);
            A, XQ, ZQ := act_with_small_ell_on_Montgomery_min(A, ell, XR/ZR, xQ);
            if twist then private_key[i] +:= 1; else private_key[i] -:= 1; end if;
          end if;
        end if;
      end if;
    end for;
    if twist then A := -A; end if;
  end while;
  return A;
end function;


function csurf_action_new(private_key, A,degree_bound)
  F := GF(p);
  A := F ! A;
  A := act_with_two_on_Montgomery_min(A,private_key[1]);
  private_key := Remove(private_key, 1);
  _<o>:=PolynomialRing(F);
  big_ells:=ells;
  small_ells:=ells;
  private_key_small:= private_key;
  small_ells:=[];
  private_key_small:=[];
  while big_ells[1] le degree_bound do
    Append(~small_ells,big_ells[1]);
    Remove(~big_ells,1);
    Append(~private_key_small,private_key[1]);
    private_key:=Remove(private_key,1);
  end while;
  alpha:=F!1;
  alpha:=Roots(o^2+A*o-1)[1][1];
  // alpha^2+A*alpha-1;

  while private_key ne [0 : i in [1..#private_key]] do
    xP := Random(F);
    twist := not IsSquare(xP^3+A*xP^2-xP); if twist then A := -A;alpha:=-alpha; xP := -xP; end if;
    indices_ells_correct_sign := [];
    k := 1;
    for i := 1 to #big_ells do
      if private_key[#big_ells-i+1] gt 0 and not twist then Append(~indices_ells_correct_sign,#big_ells-i+1); k *:= big_ells[#big_ells-i+1];
    elif private_key[#big_ells-i+1] lt 0 and twist then Append(~indices_ells_correct_sign,#big_ells-i+1); k *:= big_ells[#big_ells-i+1];
      end if;
    end for;
    XQ, ZQ := scalar_multiplication_Montgomery_min((p+1) div k, xP, 1, A);
    for i in indices_ells_correct_sign do
      if ZQ ne 0 then
        xQ := XQ/ZQ;
        ell := big_ells[i];
        k:=k div ell;
        XR, ZR := scalar_multiplication_Montgomery_min(k, xQ, 1, A);
        if ZR ne 0 then
          // Aprim,XQprime,ZQprim:=act_with_small_ell_on_Montgomery_min(A, ell, XR/ZR, xQ);
          A, XQ, ZQ,alpha := act_with_big_ell_on_Montgomery_min(A, ell, XR/ZR, xQ,alpha);

          // if A eq Aprim then
          //   "same curves";
          //   ell;
          // end if;
          // if A ne Aprim then
          //   "not the same curves";
          //   ell;
          // end if;
          if twist then private_key[i] +:= 1; else private_key[i] -:= 1; end if;
        end if;
      end if;
    end for;
    if twist then A := -A;alpha:=-alpha; end if;
  end while;

  while private_key_small ne [0 : i in [1..#private_key_small]] do
    xP := Random(F);
    twist := not IsSquare(xP^3+A*xP^2-xP); if twist then A := -A; xP := -xP; end if;
    indices_ells_correct_sign := [];
    k := 1;
    for i := 1 to #small_ells do
      if private_key_small[i] gt 0 and not twist then Append(~indices_ells_correct_sign,i); k *:= small_ells[i];
    elif private_key_small[i] lt 0 and twist then Append(~indices_ells_correct_sign,i); k *:= small_ells[i];
      end if;
    end for;
    XQ, ZQ := scalar_multiplication_Montgomery_min((p+1) div k, xP, 1, A);
    for i in indices_ells_correct_sign do
      if ells[i] eq 3 then
        if ZQ ne 0 then
          xQ := XQ/ZQ;
          // k:=k div 3;
          XR9, ZR9 := scalar_multiplication_Montgomery_min(k div 3, xQ, 1, A);
          if ZR9 ne 0 then
            XR, ZR := scalar_multiplication_Montgomery_min(3, XR9/ZR9, 1, A);
            if ZR eq 0 then
              A, XQ, ZQ := act_with_small_ell_on_Montgomery_min(A, 3, XR9/ZR9, xQ);
              if twist then private_key_small[i] +:= 1; else private_key_small[i] -:= 1; end if;
            else
              A, XQ, ZQ := act_with_small_ell_on_Montgomery_min(A, 3, XR/ZR, xQ);
              if twist then private_key_small[i] +:= 1; else private_key_small[i] -:= 1; end if;
            end if;
          end if;
        end if;
      else
        if ZQ ne 0 then
          xQ := XQ/ZQ;
          ell := small_ells[i];
          // k:=k div ell;
          XR, ZR := scalar_multiplication_Montgomery_min(k div ell, xQ, 1, A);
          if ZR ne 0 then
            // E:=EllipticCurve(o^3+A*o^2-o);
            // DivisionPoints(Id(E),2);
            A,XQ,ZQ:=act_with_small_ell_on_Montgomery_min(A, ell, XR/ZR, xQ);
            // Aprim,XQprime,ZQprim:=act_with_small_ell_on_Montgomery_min(A, ell, XR/ZR, xQ);
            // A,XQ,ZQ:=act_with_ell_on_Montgomery_min(A,ell,XR/ZR,xQ,degree_bound);

            // if A eq Aprim then
            //   "same curves";
            //   ell;
            // end if;
            // if A ne Aprim then
            //   "not the same curves";
            //   ell;
            // end if;
            // A, XQ, ZQ := act_with_small_ell_on_Montgomery_min(A, ell, XR/ZR, xQ);
            if twist then private_key_small[i] +:= 1; else private_key_small[i] -:= 1; end if;
          end if;
        end if;
      end if;
    end for;
    if twist then A := -A; end if;
  end while;
  return A;
end function;

function csurf_private_keygen()
  return [Random([-137..137])] cat [Random([-4..4]) : i in [1..3]]
         cat [Random([-5..5]) : i in [1..46]] cat [Random([-4..4]) : i in [1..25]];
end function;

find_torsion_point:=function(A,ell)
  F:=Parent(A);
  fac:=(p+1) div ell;
  repeat
    xP := Random(F);
    twist := not IsSquare(xP^3+A*xP^2-xP); if twist then A := -A; xP := -xP; end if;
    zP:=F!1;
    Xl,Zl:=scalar_multiplication_Montgomery_min(fac,xP,zP,A);
  until Zl ne 0;
  return twist,Xl,Zl;
end function;

procedure test_csurf_key_exchange(degree_bound,round)

  t1:=0;
  t2:=0;

  for i in [1..round] do
    alice_private:=csurf_private_keygen();
    bob_private:=csurf_private_keygen();
    // alice_private := [137] cat [4: i in [1..3]] cat [5: i in [1..46]] cat [-4: i in [1..25]];
    // bob_private := [-137] cat [-4: i in [1..3]] cat [-5: i in [1..46]] cat [4: i in [1..25]];
    t := Cputime();
    alice_public := csurf_action_old(alice_private,0);
    // printf "Alice's public key is %o.\n", alice_public;
    // printf "Bob's public key is %o.\n", bob_public;
    bob_public := csurf_action_old(bob_private,0);
    alice_bob := csurf_action_old(alice_private, bob_public);
    bob_alice := csurf_action_old(bob_private, alice_public);
    k1:=alice_bob;
    if alice_bob ne bob_alice then
      print "Error! The computations of the joint key do not match in old version";
    else
      t1+:=Cputime(t);
    // printf "The joint key is %o.\n", alice_bob;
    end if;

    t := Cputime();
    alice_public := csurf_action_new(alice_private,0,degree_bound);
    // printf "Alice's public key is %o.\n", alice_public;
    bob_public := csurf_action_new(bob_private,0,degree_bound);
    // printf "Bob's public key is %o.\n", bob_public;
    alice_bob := csurf_action_new(alice_private, bob_public,degree_bound);
    bob_alice := csurf_action_new(bob_private, alice_public,degree_bound);
    if alice_bob ne bob_alice then
      print "Error! The computations of the joint key do not match in new version";
    else
      t2+:=Cputime(t);
    // printf "The joint key is %o.\n", alice_bob;
    end if;
    k2:=alice_bob;
    if not k1 eq k2 then "the two methods don't give the same keys"; end if;
  end for;
  "Bound on the degree:",degree_bound;
  "Mean time of old method : ",t1/round;
  "Mean time of new method : ",t2/round;
  "decreases the time by ",(t1-t2)/t1*100,"percent";
end procedure;

procedure benchmark_speed_csurf()
  round:=1;
  degree_bounds:=[150];
  // degree_bounds:=[50,100,150,180,200,230,250,300];
  for degree_bound in degree_bounds do
    test_csurf_key_exchange(degree_bound,round);
  end for;
  "";
end procedure;
// // test();


procedure benchmark_group_action_old()
  alice_private := [137] cat [4: i in [1..3]] cat [5: i in [1..46]] cat [4: i in [1..25]];
  alice_public := csurf_action_new(alice_private,0,150);
end procedure;

sort_insert:=function(list,val)
  if list eq [] then
    return [val];
  end if;
  low:=[];
  big:=list;
  A:=big[1];
  while A le val and big ne [] do
    Append(~low,A);
    Remove(~big,1);
    if big eq [] then
      break;
    else
      A:=big[1];
    end if;
  end while;
  Append(~low,val);
  l:=low cat big;
  return l;
end function;

sort_insert_timewise:=function(list,val)
  if #list eq 0 then
    return [val];
  end if;
  low:=[];
  big:=list;
  A:=big[1];
  while A`Time le val`Time and #big ne 0 do
    Append(~low,A);
    Remove(~big,1);
    if #big eq 0 then
      break;
    else
      A:=big[1];
    end if;
  end while;
  Append(~low,val);
  l:=low cat big;
  return l;
end function;


function benchmark_old(lot,repet,max)
	if max then
  		alice_private := [137] cat [4: i in [1..3]] cat [5: i in [1..46]] cat [+4: i in [1..25]];
 	else
		alice_private:=csurf_private_keygen();
	end if;
  values:=[];
  for i in [1..repet] do
    t:=Cputime();
    for j in [1..lot] do
      x:=csurf_action_old(alice_private,0);
    end for;
    t:=Cputime(t)/lot;
    values:=sort_insert(values,t);
  end for;
  return values[#values div 2+1];
end function;

function benchmark_new(lot,repet,degree_bound,max)
 	if max then
    alice_private := [137] cat [4: i in [1..3]] cat [5: i in [1..46]] cat [+4: i in [1..25]];
  else
    alice_private:=csurf_private_keygen();
  end if;
  values:=[];
  for i in [1..repet] do
    t:=Cputime();
    for j in [1..lot] do
      x:=csurf_action_new(alice_private,0,degree_bound);
    end for;
    t:=Cputime(t)/lot;
    values:=sort_insert(values,t);
    if not max then
      alice_private:=csurf_private_keygen();
    end if;
  end for;
  return values[#values div 2+1];
end function;

procedure benchmark()
  lot:=1;
  repet:=1;
  "median upon ",repet," means on batches of size ",lot;
  degree_bounds:=[113,1000];
  //degree_bounds:=[150];
  times:=[];
  // old_time:=be:nchmark_old(lot,repet,max);
  // old_time;
  max:=true;
  for degree_bound in degree_bounds do
  Append(~times,benchmark_new(lot,repet,degree_bound,max));
  end for;
  "Results for maximal keys :";
  "degree_bound,time(s),ratio";
  old_time:=times[#times];
  for i in [1..#times] do printf "%o,%o,%o\n",degree_bounds[i],times[i],times[i]/old_time; end for;

  times:=[];
  max:=false;
  for degree_bound in degree_bounds do
  Append(~times,benchmark_new(lot,repet,degree_bound,max));
  end for;
  "Results for Random keys :";
  "degree_bound,time(s),ratio";
  old_time:=times[#times];
  for i in [1..#times] do printf "%o,%o,%o\n",degree_bounds[i],times[i],times[i]/old_time; end for;
  // "percents of improvements":
  // for i in |1..#times] do printf "%o",; end for;
  // printf "%o,%o\n",times[#times];
  // for i in [1..#times-1] do printf "%o,",degree_bounds[i]; end for;
  // printf "%o\n",degree_bounds[#times];
end procedure;


test_cutting:=procedure()
  n:=#ells;
  logs:=[Ceiling(Log(ell)/Log(2)): ell in ells];
  "one group:";
  s:=0;
  for i in [1..n] do s+:=(n-i)*logs[i]; end for;
  s;
  s:=0;
  "two group (unbalanced):";
  for i in [1..n div 2] do s+:=(1+(n div 2)-i)*(logs[i]+logs[(n div 2)+i]); end for;
  s;
  s:=0;
  "two groups (balanced):";
  for i in [1..n div 2] do s+:=(1+(n div 2)-i)*(logs[2*i]+logs[2*i-1]); end for;
  s;
  s:=0;
  "m groups (balanced):";
  m:=Ceiling(Sqrt(n));
  for i in [1..m] do
    log:=0;
    for j in [1..m] do
      if j+m*(i-1) le n then
        log+:=logs[j+m*(i-1)];
      end if;
    end for;
    s+:=(2*m-1-i)*log;
  end for;
  s;
end procedure;


procedure benchmark_action()
  // "#Speed test for isogeny computation over Fp with Log(p)=";
  // "#performed on zardoz, 3.40 Ghz, intel i7-6700 with 64Go RAM";
  // "old CSIDH action (s):";
  lot:=2;
  repet:=2;
  degree_bound:=113;
  // degree_bounds:=[150];
  // degree_bounds:=[50,100,150,200];
  // times:=[];
  // benchmark_old(lot,repet);
  // for degree_bound in degree_bounds do
  //   Append()
  //   Append(~times,benchmark_new(lot,repet,degree_bound));
  // end for;
  for i in [1..repet] do
    old:=[];
    new:=[];
    for j in [1..lot] do
      private:=csurf_private_keygen();
      t1:=ClockCycles();
      _:=csurf_action_old(private,0);
      Append(~old,ClockCycles()-t1);
      t1:=ClockCycles();
      _:=csurf_action_new(private,0,degree_bound);
      Append(~new,ClockCycles()-t1);
    end for;
    printf "action cycles ";
    for n in new do
      printf "%o ",n;
    end for;
    printf "baseline ";
    for o in old do
      printf "%o ",o;
    end for;
    printf "\n";
  end for;
  // "#the degree bound is the limit after which isogeny of this degree are evaluated using the new method in CSIDH";
  // "degree_bound,time (s)";
  // for i in [1..#times] do printf "%o,%o\n",degree_bounds[i],times[i]; end for;
  // printf "%o,%o\n",times[#times];
  // for i in [1..#times-1] do printf "%o,",degree_bounds[i]; end for;
  // printf "%o\n",degree_bounds[#times];
end procedure;

procedure benchmark_isogeny()

  repet:=15;
  F:=GF(p);
  A:= csurf_action_old(csurf_private_keygen(),0);

  for ell in ells do
    new:=[];
    old:=[];
    if ell ne 3 then
      for i in [1..repet] do
        twist,Xl,Zl:=find_torsion_point(A,ell);
        if twist then A := -A; end if;
        xQ:=Random(F);
        t1:=ClockCycles();
        _:=act_with_small_ell_on_Montgomery_min(A,ell,Xl/Zl,xQ);
        Append(~old,ClockCycles()-t1);
        t2:=ClockCycles();
        _:=act_with_big_ell_on_Montgomery_min(A,ell,Xl/Zl,xQ);
        Append(~new,ClockCycles()-t2);
      end for;
      printf "l %o cycles ",ell;
      for n in new do
        printf "%o ",n;
      end for;
      printf "baseline ";
      for o in old do
        printf "%o ",o;
      end for;
      printf "\n";
    end if;

  end for;
end procedure;

test_csurf_key_exchange(113,1);

// benchmark();
// test_cutting();
// SetProfile(true);
// t:=Cputime();
// "#Speed test for isogeny computation over Fp";
//  "#performed on zardoz, 3.40 Ghz, intel i7-6700 with 64Go RAM";
//  "random keys:";
// t:=Cputime();
// benchmark(false);
// "total time of the experiment :",Cputime(t);
// "total key exchange time :";
// Cputime(t);
// benchmark_speed_csurf();
// Cputime(t);
// time_sorted:=[];
// SetProfile(false);
// G:=ProfileGraph();
// V:=Vertices(G);
// for v in V do
//   time_sorted:=sort_insert_timewise(time_sorted,Label(v));
// end for;
// time_sorted;
// F:=GF(p);
// x:=Random(F);
// y:=Random(F);
// t:=Cputime();
// for i in [1..10283297] do
//   x:=x*y;
// end for;
// Cputime(t);
