using Nemo
using EllipticCurves
using VeluSqrt
using Test

################################# VeluSqrt

# order 240
F = GF(233)
E = Montgomery(F(3), F(1))
# print(E)
# p  = 2^32 *5^21 * 7 * 11 * 163 * 1181 * 2389 * 5233 * 8353 * 10139 * 11939 * 22003 * 25391 * 41843 * 3726787 * 6548911 -1
# print(mod(p,4))




P = XZzero(E)
while isinfinity(3 * P) || isinfinity(5 * P)
    global P = 16 * randXZ(E)
end

@test isinfinity(15 * P)

for i in 1:10
    Q = randXZ(E)
    @test isvalid(Q)
    @test isinfinity(240 * Q)
    E1, Ps = VeluRenes(P, 15, [Q, 3Q, 7Q])

    @test all(P.curve === E1 for P in Ps)
    @test all(isvalid(P) for P in Ps)
    @test 3 * Ps[1] == Ps[2]
    @test 7 * Ps[1] == Ps[3]

    E2, Ps2 = VeluResultant(P, 15, [Q, 3Q, 7Q])
    @test E2 == E1
    @test all(P1 == P2 for (P1,P2) in zip(Ps, Ps2))
end

# order 228

P = XZzero(E)
while isvalid(P) || isinfinity(3 * P) || isinfinity(19 * P)
    global P = 4 * XZPoint(rand(F), F(1), E)
end

for i in 1:10
    Q = XZPoint(rand(F), F(1), E)
    E1, Ps1 = VeluRenes(P, 57, [Q, 3Q, 7Q])
    E2, Ps2 = VeluResultant(P, 57, [Q, 3Q, 7Q])
    @test E1 == E2
    @test 3 * Ps1[1] == Ps1[2]
    @test 7 * Ps1[1] == Ps1[3]
    @test all(P1 == P2 for (P1,P2) in zip(Ps1, Ps2))
end

################################# CSIDH

###### Elligator
# order 100
F = GF(ZZ(103))
E = Montgomery(F(3), F(1))

for i in 3:10
    P, Q = VeluSqrt.Elligator2(E, F(i))

    @test isinfinity(100*P)
    @test isinfinity(108*Q)
end

###### CSIDH
s = CSIDH_setup()
for i in 1:5
    a, b = CSIDH_sk(s), CSIDH_sk(s)
    E1 = CSIDH_action(s, CSIDH_action(s, a), b)
    E2 = CSIDH_action(s, CSIDH_action(s, b), a)
    @assert E1.A == E2.A
end

###### CSURF
s = CSURF_setup()
for i in 1:5
    a, b = CSURF_sk(s), CSURF_sk(s)
    E1 = CSIDH_action(s, CSIDH_action(s, a), b)
    E2 = CSIDH_action(s, CSIDH_action(s, b), a)
    @assert E1.A == E2.A
end

# ######## BSIDH

for i in 1:3
    E, p = BSIDH_params()

    kerA = generator(E, p, :minus)
    @test isinfinity((p.p-1)*kerA)
    kerB = generator(E, p, :plus)
    @test isinfinity((p.p+1)*kerB)
    @test (((p.p+1)÷2)*kerB).X != 0

    @time E1, (AB,) = walk(kerA, p, :minus, [kerB])
    @test isinfinity((p.p+1)*AB)
    @time E1, _ = walk(AB, p, :plus)

    @time E2, (BA,) = walk(kerB, p, :plus, [kerA])
    @test isinfinity((p.p-1)*BA)
    @time E2, _ = walk(BA, p, :minus)

    @test E1.A == E2.A
end
